<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package executive
 */

?>

	</div><!-- #content -->

	<footer id="colophon" class="site-footer">
		<div class="site-credits">
			<div class="site-info">
				<?php wp_nav_menu( array( 'theme_location' => 'footer', 'fallback_cb' => 'false', 'depth' => 1 ) ); ?>

				<div class="copyright">
					<?php if ( get_theme_mod( 'executive_footer_copyright' ) ) : ?>
						<?php echo wp_kses_post( get_theme_mod( 'executive_footer_copyright' ) ); ?>
					<?php else : ?>
						&copy; <?php echo date("Y") ?> <a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php bloginfo('name'); ?>"><?php bloginfo('name'); ?></a>

						<span class="sep">&middot;</span>

						<?php printf( esc_html__( 'Built with %1$s', 'executive' ), '<a href="https://devport.net">Executive</a>' ); ?>
					<?php endif; ?>
				</div>
			</div><!-- .site-info -->

			<?php
				wp_nav_menu( array(
					'theme_location' => 'social',
					'depth' => 1,
					'link_before' => '<span class="screen-reader-text">',
					'link_after' => '</span>',
					'container_class' => 'social-links',
					'fallback_cb' => 'false',
				) );
			?>

		</div><!-- .site-credits -->
	</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
